/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.pigzombie;

import java.util.Random;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.Properties;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.ISpecialMob;
import toast.specialMobs.entity.SpecialMobData;

public class Entity_SpecialPigZombie
extends EntityPigZombie
implements ISpecialMob,
IRangedAttackMob {
    private static final double HOSTILE_CHANCE = Properties.getDouble("_mob_stats", "hostile_pigzombies");
    private static final double BOW_CHANCE = Properties.getDouble("_mob_stats", "bow_chance_pigzombie");
    private static final UUID stopModifierUUID = UUID.fromString("70A57A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier stopModifier = new AttributeModifier(stopModifierUUID, "Attacking speed boost", -1.0, 2).func_111168_a(false);
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/zombie_pigman.png")};
    public boolean isHostile;
    public byte sightDelay = (byte)20;
    public boolean seesTarget = false;
    private SpecialMobData specialData;

    public Entity_SpecialPigZombie(World world) {
        super(world);
        this.getSpecialData().isImmuneToFire = this.field_70178_ae;
        this.setRangedAI(20, 60, 13.0f);
    }

    protected void func_70088_a() {
        this.specialData = new SpecialMobData((EntityLiving)this, TEXTURES);
        super.func_70088_a();
    }

    protected void setRangedAI(int minDelay, int maxDelay, float range) {
        SpecialMobData data = this.getSpecialData();
        data.arrowRefireMin = (short)minDelay;
        data.arrowRefireMax = (short)maxDelay;
        data.arrowRange = range;
    }

    @Override
    public SpecialMobData getSpecialData() {
        return this.specialData;
    }

    @Override
    public void adjustEntityAttributes() {
        if (!this.isHostile && this.field_70146_Z.nextDouble() < HOSTILE_CHANCE) {
            NBTTagCompound entityData = new NBTTagCompound();
            this.func_70109_d(entityData);
            entityData.func_74777_a("Anger", (short)(400 + this.field_70146_Z.nextInt(400)));
            this.func_70020_e(entityData);
        }
        if (this.field_70146_Z.nextDouble() < BOW_CHANCE) {
            ItemStack itemStack = new ItemStack((Item)Items.field_151031_f);
            float tension = this.field_70170_p.func_147462_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this.field_70146_Z.nextFloat() < 0.25f * tension) {
                try {
                    EnchantmentHelper.func_77504_a((Random)this.field_70146_Z, (ItemStack)itemStack, (int)((int)(5.0f + tension * (float)this.field_70146_Z.nextInt(18))));
                }
                catch (Exception ex) {
                    _SpecialMobs.console("Error applying enchantments! entity:" + this.toString());
                    ex.printStackTrace();
                }
            }
            this.func_70062_b(0, itemStack);
        }
        float prevMax = this.func_110138_aP();
        this.adjustTypeAttributes();
        this.func_70606_j(this.func_110138_aP() + this.func_110143_aJ() - prevMax);
    }

    protected void adjustTypeAttributes() {
    }

    protected void func_70626_be() {
        this.seesTarget = false;
        super.func_70626_be();
        if (!this.seesTarget) {
            this.sightDelay = (byte)20;
            IAttributeInstance attribute = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            if (attribute.func_111127_a(stopModifierUUID) != null) {
                attribute.func_111124_b(stopModifier);
            }
        }
        if (!this.isHostile && this.field_70789_a instanceof EntityPlayer) {
            this.isHostile = true;
        }
        if (this.isHostile && !this.func_70781_l()) {
            this.field_70177_z = MathHelper.func_76142_g((float)(this.field_70177_z + (float)this.field_70146_Z.nextGaussian() * 20.0f));
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().onUpdate();
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        return this.getSpecialData().onSpawnWithEgg(data, (EntityLiving)new EntityPigZombie(this.field_70170_p));
    }

    protected void func_70785_a(Entity target, float distance) {
        boolean stopped;
        this.seesTarget = true;
        IAttributeInstance attribute = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        boolean bl = stopped = attribute.func_111127_a(stopModifierUUID) != null;
        if (this.willShootBow() && this.func_70694_bm() != null && this.func_70694_bm().func_77973_b() instanceof ItemBow) {
            if (!this.field_70170_p.field_72995_K && distance < this.getSpecialData().arrowRange) {
                boolean shouldStop;
                if (target instanceof EntityLivingBase && this.field_70724_aR <= 0) {
                    float damage = distance / this.getSpecialData().arrowRange;
                    this.field_70724_aR = (int)(damage * (float)(this.getSpecialData().arrowRefireMax - this.getSpecialData().arrowRefireMin) + (float)this.getSpecialData().arrowRefireMin);
                    damage = Math.max(0.1f, Math.min(1.0f, damage));
                    this.func_82196_d((EntityLivingBase)target, damage);
                }
                if (this.sightDelay > 0) {
                    this.sightDelay = (byte)(this.sightDelay - 1);
                }
                boolean bl2 = shouldStop = this.sightDelay <= 0;
                if (stopped != shouldStop) {
                    if (shouldStop) {
                        attribute.func_111121_a(stopModifier);
                    } else {
                        attribute.func_111124_b(stopModifier);
                    }
                }
            } else {
                this.sightDelay = (byte)20;
            }
        } else {
            if (stopped) {
                attribute.func_111124_b(stopModifier);
            }
            super.func_70785_a(target, distance);
        }
    }

    public boolean willShootBow() {
        return true;
    }

    public void func_82196_d(EntityLivingBase target, float range) {
        EntityArrow arrow = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, target, 1.6f, this.getTypeArrowSpread());
        arrow.func_70239_b((double)(range * this.getSpecialData().arrowDamage) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.field_73013_u.func_151525_a() * 0.11f));
        int power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)this.func_70694_bm());
        int punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)this.func_70694_bm());
        if (power > 0) {
            arrow.func_70239_b(arrow.func_70242_d() + (double)power * 0.5 + 0.5);
        }
        if (punch > 0) {
            arrow.func_70240_a(punch);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)this.func_70694_bm()) > 0) {
            arrow.func_70015_d(100);
        }
        this.func_85030_a("random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow);
    }

    protected float getTypeArrowSpread() {
        return this.getSpecialData().arrowSpread - (float)this.field_70170_p.field_73013_u.func_151525_a() * (this.getSpecialData().arrowSpread / 4.0f + 0.5f);
    }

    public boolean func_70652_k(Entity target) {
        this.func_71038_i();
        if (super.func_70652_k(target)) {
            this.onTypeAttack(target);
            return true;
        }
        return false;
    }

    protected void onTypeAttack(Entity target) {
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (this.isHostile) {
            saveTag.func_74757_a("SMAnger", true);
        }
        this.getSpecialData().isImmuneToFire = this.field_70178_ae;
        this.getSpecialData().writeToNBT(saveTag);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        this.isHostile = saveTag.func_74764_b("SMAnger") ? saveTag.func_74767_n("SMAnger") : (tag.func_74764_b("SMAnger") ? tag.func_74767_n("SMAnger") : tag.func_74765_d("Anger") != 0);
        this.getSpecialData().readFromNBT(tag);
        this.getSpecialData().readFromNBT(saveTag);
        this.field_70178_ae = this.getSpecialData().isImmuneToFire;
    }

    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        if (this.func_70694_bm() != null && this.func_70694_bm().func_77973_b() instanceof ItemBow) {
            int i = this.field_70146_Z.nextInt(3 + looting);
            while (i-- > 0) {
                this.func_145779_a(Items.field_151032_g, 1);
            }
        }
    }

    public int func_70658_aO() {
        return Math.min(20, super.func_70658_aO() + this.getSpecialData().armor);
    }

    public void func_70015_d(int time) {
        if (!this.getSpecialData().isImmuneToBurning) {
            super.func_70015_d(time);
        }
    }

    public boolean func_110164_bC() {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing;
    }

    public void func_70110_aj() {
        if (!this.getSpecialData().isImmuneToWebs) {
            super.func_70110_aj();
        }
    }

    protected void func_70069_a(float distance) {
        if (!this.getSpecialData().isImmuneToFalling) {
            super.func_70069_a(distance);
        }
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates;
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater;
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush;
    }

    public boolean func_70687_e(PotionEffect effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }
}

